/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.01)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

/* AMBIENT LIGHT */
#define _AMBIENT	0., .05, .1

/* DIFFUSE LIGHT */
#define _DIFFUSE	0., (sin(iGlobalTime)*.4+.7)*.85, (sin(iGlobalTime+3.141592653)*.4+.7)*.75
#define _DIFINTENSITY 1.1
#define _LIGHTSIZE 4.

/* SPECULAR HIGHLIGHTS */
#define _SPECCOL	0., .75, 1.
#define _SPECEXP	128.

void main ( void )
{
	vec2 uv = gl_FragCoord.xy/iResolution.xy; //Normal UVs
    vec2 uvs = 1./iResolution.xy;		   //Pixel coord in [0..1] range
    vec2 co = gl_FragCoord.xy/iResolution.yy; //Square UVs
    
    float n = texture2D(iChannel0, vec2(uv.x,uv.y+uvs.y)).r;		 //Sample Moore neighborhood
    float ne = texture2D(iChannel0, vec2(uv.x+uvs.x,uv.y+uvs.y)).r;
    float e = texture2D(iChannel0, vec2(uv.x+uvs.x,uv.y)).r;
    float se = texture2D(iChannel0, vec2(uv.x+uvs.x,uv.y-uvs.y)).r;
    float s = texture2D(iChannel0, vec2(uv.x,uv.y-uvs.y)).r;
    float sw = texture2D(iChannel0, vec2(uv.x-uvs.x,uv.y-uvs.y)).r;
    float w = texture2D(iChannel0, vec2(uv.x-uvs.x,uv.y)).r;
    float nw = texture2D(iChannel0, vec2(uv.x-uvs.x,uv.y+uvs.y)).r;
    
    float dx = (nw+2.*w+sw)-(ne+2.*e+se); //Sobel operator x
    float dy = (sw+2.*s+se)-(nw+2.*n+ne); //Sobel operator y
    float dz = texture2D(iChannel0,uv).r*.5+.5; //Height
    
    vec3 nm = normalize(vec3(dx,dy,dz)); //Convert heightmap to normalmap
    
    vec3 lp = vec3((iMouse.xy/iResolution.yy),1.5); //Light position
    vec3 lv = normalize(vec3(lp.x-co.x,lp.y-co.y,lp.z-dz)); //Calculate light vector
    float li = pow(_DIFINTENSITY-(distance(lp,vec3(co,dz))/_LIGHTSIZE),3.); //Calculate light intensity
    
    float dif = dot(lv,nm); //Diffuse lighting
    float sp = pow(dot(lv,nm),_SPECEXP); //Specular lighting
    
    vec3 res = vec3(_AMBIENT)+vec3(dif)*vec3(_DIFFUSE)*li+vec3(sp)*vec3(_SPECCOL)*li; //Add lighting results together
	 gl_FragColor = vec4(res,1.);
}